# 创建视图

Joe 想要基于 

```mysql
create table employee(
    id int primary key auto_increment,
    name varchar(256),
    address varchar(1024),
    dept varchar(64)
    -- ignore more
);

create table customer(
                         id int primary key auto_increment,
                         name varchar(256),
                         address varchar(1024),
                         level int
    -- ignore more
)
```

创建视图 v_addresses，包含写姓名和地址两列。下列哪个正确？

## 答案

```mysql
create view v_addresses as
    select name, address from employee
    union
    select name, address from customer;
```

## 选项

### A

```mysql
create view v_addresses as
    select * from employee
    union
    select * from customer;
```

### B

```mysql
create view v_addresses as
    select name, address from employee
    union
    select name, address from customer;
```

### C

```mysql
create view v_addresses as
begin;
    select name, address from employee
    select name, address from customer;
end;
```

### D

```mysql
create view v_addresses
    select name, address from employee
    union
    select name, address from customer;
```
